package MusicLandscape.util.formatters;

import MusicLandscape.entities.Track;
import MusicLandscape.util.MyFormatter;

/**
 * This class represents the concept of csv-formatting of a track.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 2
 * @since ExerciseSheet04
 */
public class CSVTrackFormatter implements MyFormatter<Track> {
    /**
     * comma separated list of all column names in the following order:
     *
     * <ol>
     *   <li>Title</li>
     *   <li>Writer</li>
     *   <li>Performer</li>
     *   <li>duration</li>
     *   <li>year</li>
     * </ol>
     *
     * No new line is added at the end of the String!.
     */
    @Override
    public String header() {
        return "Title," +
                "Writer," +
                "Performer," +
                "Duration," +
                "Year";
    }

    /**
     * Creates a CSV format of a track.
     * <p>
     * The csv representation of a track is "title","performer","writer","year","duration"; (without quotes)<br>
     * No new line is added at the end of the String!
     *
     * @param t the track to be formatted
     * @return the formatted String representing the track
     */
    @Override
    public String format(Track t) {
        return t.getTitle() +
                "," +
                t.getPerformer() +
                "," +
                t.getWriter() +
                "," +
                t.getYear() +
                "," +
                t.getDuration() +
                ";";
    }

    /**
     * the top separator for this format is the empty string.<br>
     * No new line is added at the end of the String!.
     *
     * @return the separator.
     */
    @Override
    public String topSeparator() {
        return "";
    }
}
